using UnityEngine;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System;
using Newtonsoft.Json.Linq;

namespace quicksdk
{
	public class QuickSDK
	{
		private static QuickSDK _instance;

		public static QuickSDK getInstance() {
			if( null == _instance ) {
				_instance = new QuickSDK();
            }
			return _instance;
		}

		public void setListener(QuickSDKListener listener)
		{
			QuickSDKImp.getInstance ().setListener (listener);
        }

        //
        public void init()
        {
			QuickSDKImp.getInstance ().init();
        }

		public void login ()
		{
			QuickSDKImp.getInstance ().login();
        }

		public void googleLogin ()
		{
			QuickSDKImp.getInstance ().googleLogin();
        }


		public void facebookLogin ()
		{
			QuickSDKImp.getInstance ().facebookLogin();
        }

		public void logout ()
		{
			QuickSDKImp.getInstance ().logout();
        }

		public void userTrash ()
		{
			QuickSDKImp.getInstance ().userTrash();
        }

		public void userTrashNoUI ()
		{
			QuickSDKImp.getInstance ().userTrashNoUI();
        }

		public void pay (OrderInfo orderInfo, GameRoleInfo gameRoleInfo)
		{
			QuickSDKImp.getInstance ().pay(orderInfo, gameRoleInfo);
        }

		public void updateRole(GameRoleInfo gameRoleInfo){
			QuickSDKImp.getInstance ().updateRoleInfoWith (gameRoleInfo);//角色升级
		}

		public void afUpdateRole(int isCreate,GameRoleInfo gameRoleInfo){
			QuickSDKImp.getInstance ().afUpdateRoleInfo (isCreate, gameRoleInfo);//角色升级
		}

		public void callFacebookSharePost(string serverId,string roleId )
		{
			QuickSDKImp.getInstance ().callFacebookSharePost (serverId,roleId);
		}

		public void fbShareUrl(string url){
			QuickSDKImp.getInstance ().fbShareUrl (url);
		}

		public void fbShareImg(string imgPath){
			QuickSDKImp.getInstance ().fbShareImg (imgPath);
		}

		public void userCenter( )
		{
			QuickSDKImp.getInstance ().userCenter ();
		}

		public void showFloat( )
		{
			QuickSDKImp.getInstance ().showFloat ();
		}

		public void closeFloat( )
		{
			QuickSDKImp.getInstance ().closeFloat ();
		}

		public void facebookEvent(string eventName,double valueNum,Dictionary<string, string> eventParams )
		{
			QuickSDKImp.getInstance ().facebookEvent (eventName, valueNum,eventParams);
		}

		public void facebookInitiatedCheckoutEvent(string goodsName, string goodsId, string goodsType, int numItems, bool paymentInfoAvailable, string currency, double totalPrice)
		{
			QuickSDKImp.getInstance ().facebookInitiatedCheckoutEvent (goodsName, goodsId, goodsType, numItems, paymentInfoAvailable, currency, totalPrice);
		}

		public void facebookPurchase(double purchaseAmount, String currency, Dictionary<string, string> eventParams)
		{
			QuickSDKImp.getInstance ().facebookPurchase (purchaseAmount, currency, eventParams);
		}

		public void appsFlyerEvent(string eventName,Dictionary<string, string> eventParams )
		{
			QuickSDKImp.getInstance ().appsFlyerEvent (eventName, eventParams);
		}

		public void firebaseEvent(string eventName,Dictionary<string, string> eventParams )
		{
			QuickSDKImp.getInstance ().firebaseEvent (eventName, eventParams);
		}

		public void adjustEvent(string eventToken )
		{
			QuickSDKImp.getInstance ().adjustEvent (eventToken);
		}

		public void adjustEvent(string eventToken, Dictionary<string, string> extendParams)
		{
			QuickSDKImp.getInstance ().adjustEvent (eventToken, extendParams);
		}

		public void adjustEvent(string eventToken, string orderId, double amount,string currency )
		{
			QuickSDKImp.getInstance ().adjustEvent (eventToken, orderId, amount, currency);
		}

		public void adjustEvent(string eventToken, string orderId, double amount,string currency, Dictionary<string, string> extendParams )
		{
			QuickSDKImp.getInstance ().adjustEvent (eventToken, orderId, amount, currency, extendParams);
		}

		public void adjustAdRevenue(string source, double revenue, string currency, int impressionsCount,string revenueNetwork,
        string revenueUnit,string adRevenuePlacement, Dictionary<string, string> extendParams )
		{
			QuickSDKImp.getInstance ().adjustAdRevenue (source, revenue, currency, impressionsCount, revenueNetwork, revenueUnit, adRevenuePlacement, extendParams);
		}

		public void tapDBEvent(string eventName, JObject properties)
		{
			QuickSDKImp.getInstance ().tapDBEvent (eventName, properties);
		}

		public void tapDBRegisterStaticProperties(JObject properties )
		{
			QuickSDKImp.getInstance ().tapDBRegisterStaticProperties (properties);
		}

		public void tapDBUnregisterStaticProperty(string propertyName )
		{
			QuickSDKImp.getInstance ().tapDBUnregisterStaticProperty (propertyName);
		}

		public void tapDBClearStaticProperties()
		{
			QuickSDKImp.getInstance ().tapDBClearStaticProperties ();
		}

		public void tapDBDeviceUpdate(JObject properties )
		{
			QuickSDKImp.getInstance ().tapDBDeviceUpdate (properties);
		}

		public void tapDBDeviceInitialize(JObject properties )
		{
			QuickSDKImp.getInstance ().tapDBDeviceInitialize (properties);
		}

		public void tapDBDeviceAdd(JObject properties )
		{
			QuickSDKImp.getInstance ().tapDBDeviceAdd (properties);
		}

		public void tapDBUserUpdate(JObject properties )
		{
			QuickSDKImp.getInstance ().tapDBUserUpdate (properties);
		}

		public void tapDBUserInitialize(JObject properties )
		{
			QuickSDKImp.getInstance ().tapDBUserInitialize (properties);
		}

		public void tapDBUserAdd(JObject properties )
		{
			QuickSDKImp.getInstance ().tapDBUserAdd (properties);
		}

		public void queryGoogleSku(List<string> goodsIds)
		{
			QuickSDKImp.getInstance ().queryGoogleSku (goodsIds);
		}

		public void shareToTikTok(string filePath)
		{
			QuickSDKImp.getInstance ().shareToTikTok (filePath);
		}

		public void shareToTikTok(List<string> filePaths)
		{
			QuickSDKImp.getInstance ().shareToTikTok (filePaths);
		}

		public void shareVideoToTikTok(string filePath)
		{
			QuickSDKImp.getInstance ().shareVideoToTikTok (filePath);
		}

		public void shareToIns(string filePath)
		{
			QuickSDKImp.getInstance ().shareToIns (filePath);
		}

		public void freeLogin()
		{
			QuickSDKImp.getInstance ().freeLogin ();
		}

		public string getAppsFlyerId()
		{
			return QuickSDKImp.getInstance ().getAppsFlyerId();
		}

		public string getUserId()
		{
			return QuickSDKImp.getInstance ().getUserId();
		}

		public Dictionary<string, string> getCountryInfo()
		{
			return QuickSDKImp.getInstance ().getCountryInfo();
		}
		public void bindUser(string bindType){
			QuickSDKImp.getInstance ().bindUser(bindType);
		}

		public void initCustomService(string appId, string uid, string userName, string roleId, string roleName, string serverName, string vipLv, string channelCode, string deviceName, string title)
		{
			QuickSDKImp.getInstance ().initCustomService (appId,uid,userName,roleId,roleName,serverName,vipLv,channelCode,deviceName,title);
		}

		public void goChatActivity()
		{
			QuickSDKImp.getInstance ().goChatActivity ();
		}

		public void singleGameOrderFinish(string sdkOrderId){
			QuickSDKImp.getInstance ().singleGameOrderFinish(sdkOrderId);
		}

		public void thinkingDataLogin(string identification)
		{
			QuickSDKImp.getInstance ().thinkingDataLogin (identification);
		}

		public void thinkingDataSetSuperProperties(JObject properties)
		{
			QuickSDKImp.getInstance ().thinkingDataSetSuperProperties (properties);
		}

		public void thinkingDataEnableAutoTrack(int type)
		{
			QuickSDKImp.getInstance ().thinkingDataEnableAutoTrack ( type);
		}

		public void thinkingDataTrack(string eventName, JObject properties)
		{
			QuickSDKImp.getInstance ().thinkingDataTrack (eventName, properties);
		}

		public void thinkingDataUserSet(JObject properties)
		{
			QuickSDKImp.getInstance ().thinkingDataUserSet (properties);
		}

		public bool checkHasPermission(string permission)
		{
			return QuickSDKImp.getInstance ().checkHasPermission(permission);
		}

		public void openReview()
		{
			QuickSDKImp.getInstance ().openReview();
		}

		public void getAdjustId()
		{
			QuickSDKImp.getInstance ().getAdjustId();
		}
	}
}
